%This file plots cumulative COVID deaths for select states

clear all;
close all;
h = 1;

% Load the data
data = readtable('Weeklydeaths3.xlsx');

% Convert 'data_period_start' and 'data_period_end' to datetime
% Given the format 'M/D/YY'
data.data_period_start = datetime(data.data_period_start, 'InputFormat', 'MM/dd/yy');
data.data_period_end = datetime(data.data_period_end, 'InputFormat', 'MM/dd/yy');

% Fill missing values for specific numeric columns
numericColumns = {'COVID_deaths', 'COVID_pct_of_total', 'crude_COVID_rate', 'aa_COVID_rate', 'crude_COVID_rate_ann', 'aa_COVID_rate_ann'};
for col = numericColumns
    data.(col{1}) = fillmissing(data.(col{1}), 'constant', 0);
end

% Filter data starting from January 1, 2020
startDate = datetime(2020, 1, 1);
data = data(data.data_period_start >= startDate, :);

% Ask user to select states (example: {'State1', 'State2'})
%selectedStates = { 'Mississippi','New York City','Oklahoma','Puerto Rico','Hawaii','Vermont'};  % Replace with actual state names
selectedStates = {'West Virginia', 'Mississippi','New York City','Oklahoma','Utah','Hawaii','Vermont','Oregon'}; 

% Ask user to select between 'total' and 'weekly' deaths
plotType = 'total';  % Replace with user input: 'total' or 'weekly'

% Filter data for selected states and plot type
stateData = data(ismember(data.State, selectedStates) & ...
                 strcmp(data.Group, plotType), :);

% Plotting
figure(h);
for state = selectedStates
    stateSpecificData = stateData(ismember(stateData.State, state), :);
    
    % Decide whether to plot cumulative or weekly deaths
    if strcmp(plotType, 'total')
        % For cumulative deaths, plot against the period end date
        plot(stateSpecificData.data_period_end, stateSpecificData.aa_COVID_rate,'LineWidth',1.5);
    else
        % For weekly deaths, plot against the period start date
        plot(stateSpecificData.data_period_start, stateSpecificData.aa_COVID_rate);
    end
    hold on;
end
xlabel('Date');
ylabel(['COVID Deaths (' plotType ')']);
title(['COVID Deaths by State Age Adjusted Rate per 100K (' plotType ')']);
datetick('x', 'mm/dd/yy');
legend(selectedStates,'Location','northwest');
hold off;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
exportgraphics(gcf,'FigureB7Right.pdf','ContentType','vector')

h = h+1;

% Ask user to select states (example: {'State1', 'State2'})
%selectedStates = { 'Mississippi','New York City','Oklahoma','Puerto Rico','Hawaii','Vermont'};  % Replace with actual state names
selectedStates = {'United States','New York City'}; 

% Ask user to select between 'total' and 'weekly' deaths
plotType = 'weekly';  % Replace with user input: 'total' or 'weekly'

% Filter data for selected states and plot type
stateData = data(ismember(data.State, selectedStates) & ...
                 strcmp(data.Group, plotType), :);

figure(h);
for state = selectedStates
    stateSpecificData = stateData(ismember(stateData.State, state), :);
    
    % Decide whether to plot cumulative or weekly deaths
    if strcmp(plotType, 'total')
        % For cumulative deaths, plot against the period end date
        plot(stateSpecificData.data_period_end, stateSpecificData.aa_COVID_rate,'LineWidth',1.5);
    else
        % For weekly deaths, plot against the period start date
        plot(stateSpecificData.data_period_start, stateSpecificData.aa_COVID_rate,'LineWidth',1.5);
    end
    hold on;
end
xlabel('Date');
ylabel(['COVID Deaths (' plotType ')']);
title(['COVID Deaths by State Age Adjusted Rate per 100K (' plotType ')']);
datetick('x', 'mm/dd/yy');
legend(selectedStates,'Location','northeast');
hold off;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
%exportgraphics(gcf,'USandNYC.pdf','ContentType','vector')

h = h+1;

figure(h);


% Ask user to select states (example: {'State1', 'State2'})
%selectedStates = { 'Mississippi','New York City','Oklahoma','Puerto Rico','Hawaii','Vermont'};  % Replace with actual state names
%selectedStates = {'Utah','Hawaii','Vermont','Oregon'}; 
selectedStates2 = {'Alabama','Alaska','Arizona','Arkansas','California','Colorado','Connecticut','Deleware','District of Columbia','Florida','Georgia','Hawaii','Idaho','Illinois','Indiana','Iowa','Kansas','Kentucky','Louisiana','Maine','Maryland','Massachussets','Michigan','Minnesota','Mississippi','Missouri','Montana','Nebraska','Nevada','New Hampshire','New Jersey','New Mexico','New York','North Carolina','North Dakota','Ohio','Oklahoma','Oregon','Pennsylvania','Puerto Rico','Rhode Island','South Carolina','South Dakota','Tennessee','Texas','Utah','Vermont','Virginia','Washington','West Virginia','Wisconsin','Wyoming'};

% Ask user to select between 'total' and 'weekly' deaths
plotType = 'weekly';  % Replace with user input: 'total' or 'weekly'


% Filter data for selected states and plot type
stateData2 = data(ismember(data.State, selectedStates2) & ...
                 strcmp(data.Group, plotType), :);

hold on;
for state = selectedStates2
    stateSpecificData = stateData2(ismember(stateData2.State, state), :);
    
    % Decide whether to plot cumulative or weekly deaths
    if strcmp(plotType, 'total')
        % For cumulative deaths, plot against the period end date
        plot(stateSpecificData.data_period_end, stateSpecificData.aa_COVID_rate, 'color', [.8 .8 .8]);
    else
        % For weekly deaths, plot against the period start date
        plot(stateSpecificData.data_period_start, stateSpecificData.aa_COVID_rate, 'color', [.8 .8 .8]);
    end
   
end

 state = selectedStates(1)
    stateSpecificData = stateData(ismember(stateData.State, state), :);
    
    % Decide whether to plot cumulative or weekly deaths
    if strcmp(plotType, 'total')
        % For cumulative deaths, plot against the period end date
        plot(stateSpecificData.data_period_end, stateSpecificData.aa_COVID_rate,'LineWidth',2);
    else
        % For weekly deaths, plot against the period start date
        plot(stateSpecificData.data_period_start, stateSpecificData.aa_COVID_rate,'LineWidth',2,'Color',"blue");
    end

    state = selectedStates(2)
    stateSpecificData = stateData(ismember(stateData.State, state), :);
    
    % Decide whether to plot cumulative or weekly deaths
    if strcmp(plotType, 'total')
        % For cumulative deaths, plot against the period end date
        plot(stateSpecificData.data_period_end, stateSpecificData.aa_COVID_rate,'LineWidth',2);
    else
        % For weekly deaths, plot against the period start date
        plot(stateSpecificData.data_period_start, stateSpecificData.aa_COVID_rate,'LineWidth',2,'Color',"red");
    end
  

xlabel('Date');
ylabel(['COVID Deaths (' plotType ')']);
ylim([0 50]);
title(['COVID Deaths by State Age-Adjsuted Rate per 100K (' plotType ')']);
datetick('x', 'mm/dd/yy');
%legend(selectedStates,'Location','northeast');
hold off;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
exportgraphics(gcf,'FigureB9.pdf','ContentType','vector')

h = h+1;


% Ask user to select states (example: {'State1', 'State2'})
%selectedStates = { 'Mississippi','New York City','Oklahoma','Puerto Rico','Hawaii','Vermont'};  % Replace with actual state names
selectedStates = {'New York and New York City','Texas','California','Florida'}; 

% Ask user to select between 'total' and 'weekly' deaths
plotType = 'total';  % Replace with user input: 'total' or 'weekly'

% Filter data for selected states and plot type
stateData = data(ismember(data.State, selectedStates) & ...
                 strcmp(data.Group, plotType), :);

% Plotting
figure(h);
for state = selectedStates
    stateSpecificData = stateData(ismember(stateData.State, state), :);
    
    % Decide whether to plot cumulative or weekly deaths
    if strcmp(plotType, 'total')
        % For cumulative deaths, plot against the period end date
        plot(stateSpecificData.data_period_end, stateSpecificData.aa_COVID_rate,'LineWidth',1.5);
    else
        % For weekly deaths, plot against the period start date
        plot(stateSpecificData.data_period_start, stateSpecificData.aa_COVID_rate);
    end
    hold on;
end
xlabel('Date');
ylabel(['COVID Deaths (' plotType ')']);
title(['COVID Deaths by State Age Adjusted Rate per 100K (' plotType ')']);
datetick('x', 'mm/dd/yy');
legend(selectedStates,'Location','northwest');
hold off;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
exportgraphics(gcf,'FigureB7Left.pdf','ContentType','vector')

h = h+1;

% Filter data for the group 'total' and the specific data period
selectedDate = datetime('11/4/2023', 'InputFormat', 'MM/dd/yyyy');
regionsToExclude = {'Region 1', 'Region 2', 'Region 3', 'Region 4', 'Region 5', 'Region 6', 'Region 7', 'Region 8', 'Region 9', 'Region 10','New York and New York City'};
dataFiltered = data(data.data_period_end == selectedDate & ...
                    strcmp(data.Group, 'total') & ...
                    ~ismember(data.State, regionsToExclude), :);

% Plotting the 'crude_COVID_rate' for all states on the selected date
figure(h);
barh(categorical(dataFiltered.State), dataFiltered.crude_COVID_rate);
xlabel('Crude COVID Death Rate per 100K');
title('Crude COVID Rate by State on 11/4/2023');
h = h+1;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
%exportgraphics(gcf,'cumdeaths11_4_2023crude.pdf','ContentType','vector')

% Plotting the 'crude_COVID_rate' for all states on the selected date
figure(h);
barh(categorical(dataFiltered.State), dataFiltered.aa_COVID_rate);
xlabel('Age Adjusted COVID Death Rate per 100K');
title('Age Adjusted COVID Death Rate by State on 11/4/2023');
h = h+1;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
%exportgraphics(gcf,'cumdeaths11_4_2023ageadj.pdf','ContentType','vector')


% Filter data for the group 'total' and the specific data period
selectedDate = datetime('4/2/2022', 'InputFormat', 'MM/dd/yyyy');
regionsToExclude = {'Region 1', 'Region 2', 'Region 3', 'Region 4', 'Region 5', 'Region 6', 'Region 7', 'Region 8', 'Region 9', 'Region 10','New York and New York City'};
dataFiltered = data(data.data_period_end == selectedDate & ...
                    strcmp(data.Group, 'total') & ...
                    ~ismember(data.State, regionsToExclude), :);

% Plotting the 'aa_COVID_rate' for all states on the selected date
figure(h);
barh(categorical(dataFiltered.State), dataFiltered.aa_COVID_rate);
xlabel('Age Adjusted COVID Death Rate per 100K');
title('Age Adjusted COVID Cumulative Death Rate on 4/2/2022');
h = h+1;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
exportgraphics(gcf,'FigureB10Left.pdf','ContentType','vector')

% Filter data for the group 'total' and the specific data period
selectedDate = datetime('4/2/2022', 'InputFormat', 'MM/dd/yyyy');
dataFiltered1 = data(data.data_period_end == selectedDate & ...
                    strcmp(data.Group, 'total') & ...
                    ~ismember(data.State, regionsToExclude), :);

selectedDate = datetime('12/30/2023', 'InputFormat', 'MM/dd/yyyy');
dataFiltered2 = data(data.data_period_end == selectedDate & ...
                    strcmp(data.Group, 'total') & ...
                     ~ismember(data.State, regionsToExclude), :);


% Plotting the 'crude_COVID_rate' for all states on the selected date
figure(h);
barh(categorical(dataFiltered1.State), dataFiltered2.aa_COVID_rate - dataFiltered1.aa_COVID_rate  );
xlim([0 400])
xlabel('Age Adjusted COVID Death Rate per 100K');
title('Age Adjusted COVID Cumulative Death Rate between 4/2/2022 and 12/30/2023');
h = h+1;
hh=gcf;
set(hh,'PaperOrientation','landscape');
set(hh,'PaperUnits','normalized');
set(hh,'PaperPosition', [0 0 1 1]);
ax = gca;
ax.YAxis.FontSize = 8;
exportgraphics(gcf,'FigureB10Right.pdf','ContentType','vector')
